//*****************************************************************************
//
// lis3dsh.h - Macros used when accessing the ST LIS3DSH accelerometer
//
// * THis provides an interface to access accelerometer data from the LIS3DSH.

// * This code is modified from lsm303dlhc_accel.h that is provided as part of
// * revision 1.1 of the Tiva Firmware Development Package, from Texas Instruments Incorporated.
// *
// * Written by Dale Tardiff, Innovative Power Solutions Inc.
// * Version 0.1 - Started Jan 31, 2014
//
//*****************************************************************************

#ifndef __SENSORLIB_LIS3DSH_H__
#define __SENSORLIB_LIS3DSH_H__

//*****************************************************************************
//
// If building with a C++ compiler, make all of the definitions in this header
// have a C binding.
//
//*****************************************************************************
#ifdef __cplusplus
extern "C"
{
#endif

//*****************************************************************************
//
// The structure that defines the internal state of the LIS3DSH driver.
//
//*****************************************************************************
typedef struct
{
    //
    // The pointer to the I2C master interface instance used to communicate
    // with the LIS3DSH.
    //
    tI2CMInstance *psI2CInst;

    //
    // The I2C address of the LIS3DSH.
    //
    uint8_t ui8Addr;

    //
    // The state of the state machine used while accessing the LIS3DSH.
    //
    uint8_t ui8State;

    //
    // The current accelerometer afs_sel setting.
    //
    uint8_t ui8AccelAfsSel;

    //
    // The new accelerometer afs_sel setting, which is used when a register
    // write succeeds.
    //
    uint8_t ui8NewAccelAfsSel;

    //
    // The data buffers used for sending/receiving data to/from the LIS3DSH.
    //
    uint8_t pui8Data[8];

    //
    // The function that is called when the current request has completed
    // processing.
    //
    tSensorCallback *pfnCallback;

    //
    // The callback data provided to the callback function.
    //
    void *pvCallbackData;

    //
    // A union of structures that are used for read, write and
    // read-modify-write operations.  Since only one operation can be active at
    // a time, it is safe to re-use the memory in this manner.
    //
    union
    {
        //
        // A buffer used to store the write portion of a register read.
        //
        uint8_t pui8Buffer[2];

        //
        // The write state used to write register values.
        //
        tI2CMWrite8 sWriteState;

        //
        // The read-modify-write state used to modify register values.
        //
        tI2CMReadModifyWrite8 sReadModifyWriteState;
    }
    uCommand;
}tLIS3DSH;

//*****************************************************************************
//
// Function prototypes.
//
//*****************************************************************************
extern uint_fast8_t LIS3DSHInit(tLIS3DSH *psInst,
                                        tI2CMInstance *psI2CInst,
                                        uint_fast8_t ui8I2CAddr,
                                        tSensorCallback *pfnCallback,
                                        void *pvCallbackData);
extern uint_fast8_t LIS3DSHRead(tLIS3DSH *psInst,
                                        uint_fast8_t ui8Reg,
                                        uint8_t *pui8Data,
                                        uint_fast16_t ui16Count,
                                        tSensorCallback *pfnCallback,
                                        void *pvCallbackData);
extern uint_fast8_t LIS3DSHWrite(tLIS3DSH *psInst,
                                         uint_fast8_t ui8Reg,
                                         const uint8_t *pui8Data,
                                         uint_fast16_t ui16Count,
                                         tSensorCallback *pfnCallback,
                                         void *pvCallbackData);
extern uint_fast8_t LIS3DSHReadModifyWrite(tLIS3DSH *psInst,
                                                   uint_fast8_t ui8Reg,
                                                   uint_fast8_t ui8Mask,
                                                   uint_fast8_t ui8Value,
                                                   tSensorCallback *pfnCallbak,
                                                   void *pvCallbackData);
extern uint_fast8_t LIS3DSHDataRead(tLIS3DSH *psInst,
                                            tSensorCallback *pfnCallback,
                                            void *pvCallbackData);
extern void LIS3DSHDataGetRaw(tLIS3DSH *psInst,
                                           uint_fast16_t *pui16AccelX,
                                           uint_fast16_t *pui16AccelY,
                                           uint_fast16_t *pui16AccelZ);
extern void LIS3DSHDataGetFloat(tLIS3DSH *psInst,
                                             float *pfAccelX, float *pfAccelY,
                                             float *pfAccelZ);

//*****************************************************************************
//
// Mark the end of the C bindings section for C++ compilers.
//
//*****************************************************************************
#ifdef __cplusplus
}
#endif

#endif // __SENSORLIB_LIS3DSH__H__
